/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.ClassPool;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.instruction.BranchInstruction;
import proguard.classfile.instruction.CpInstruction;
import proguard.classfile.instruction.InstructionVisitor;
import proguard.classfile.instruction.LookUpSwitchInstruction;
import proguard.classfile.instruction.SimpleInstruction;
import proguard.classfile.instruction.TableSwitchInstruction;
import proguard.classfile.instruction.VariableInstruction;
import proguard.classfile.util.ClassForNameChecker;
import proguard.classfile.util.ClassNewInstanceChecker;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.util.ClassNameListMatcher;

public class ClassFileClassForNameReferenceInitializer
implements InstructionVisitor,
CpInfoVisitor {
    private ClassPool programClassPool;
    private ClassPool libraryClassPool;
    private boolean note;
    private ClassNameListMatcher noteExceptionMatcher;
    private int noteCount;
    private int ldcStringCpIndex = -1;
    private int invokestaticMethodRefCpIndex = -1;
    private int invokevirtualMethodRefCpIndex = -1;
    private ClassForNameChecker classForNameChecker = new ClassForNameChecker();
    private ClassNewInstanceChecker classNewInstanceChecker = new ClassNewInstanceChecker();

    public ClassFileClassForNameReferenceInitializer(ClassPool classPool, ClassPool classPool2) {
        this(classPool, classPool2, true, null);
    }

    public ClassFileClassForNameReferenceInitializer(ClassPool classPool, ClassPool classPool2, boolean bl, ClassNameListMatcher classNameListMatcher) {
        this.programClassPool = classPool;
        this.libraryClassPool = classPool2;
        this.note = bl;
        this.noteExceptionMatcher = classNameListMatcher;
    }

    public int getNoteCount() {
        return this.noteCount;
    }

    public void visitSimpleInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, SimpleInstruction simpleInstruction) {
        this.clearConstantPoolIndices();
    }

    public void visitBranchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, BranchInstruction branchInstruction) {
        this.clearConstantPoolIndices();
    }

    public void visitTableSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, TableSwitchInstruction tableSwitchInstruction) {
        this.clearConstantPoolIndices();
    }

    public void visitLookUpSwitchInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, LookUpSwitchInstruction lookUpSwitchInstruction) {
        this.clearConstantPoolIndices();
    }

    public void visitVariableInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, VariableInstruction variableInstruction) {
        switch (variableInstruction.opcode) {
            case 3: 
            case 4: {
                break;
            }
            default: {
                this.ldcStringCpIndex = -1;
            }
        }
        this.invokestaticMethodRefCpIndex = -1;
        this.invokevirtualMethodRefCpIndex = -1;
    }

    public void visitCpInstruction(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, CpInstruction cpInstruction) {
        int n2 = cpInstruction.cpIndex;
        switch (cpInstruction.opcode) {
            case 18: 
            case 19: {
                int n3 = classFile.getCpTag(n2);
                this.ldcStringCpIndex = n3 == 8 ? n2 : -1;
                this.invokestaticMethodRefCpIndex = -1;
                this.invokevirtualMethodRefCpIndex = -1;
                break;
            }
            case -72: {
                if (this.ldcStringCpIndex > 0) {
                    if (this.classForNameChecker.check(classFile, n2)) {
                        classFile.constantPoolEntryAccept(this.ldcStringCpIndex, this);
                    }
                    this.invokestaticMethodRefCpIndex = -1;
                } else {
                    this.invokestaticMethodRefCpIndex = n2;
                }
                this.ldcStringCpIndex = -1;
                this.invokevirtualMethodRefCpIndex = -1;
                break;
            }
            case -74: {
                if (this.invokestaticMethodRefCpIndex > 0) {
                    this.invokevirtualMethodRefCpIndex = n2;
                } else {
                    this.invokestaticMethodRefCpIndex = -1;
                    this.invokevirtualMethodRefCpIndex = -1;
                }
                this.ldcStringCpIndex = -1;
                break;
            }
            case -64: {
                if (this.invokestaticMethodRefCpIndex > 0 && this.invokevirtualMethodRefCpIndex > 0 && this.classForNameChecker.check(classFile, this.invokestaticMethodRefCpIndex) && this.classNewInstanceChecker.check(classFile, this.invokevirtualMethodRefCpIndex)) {
                    classFile.constantPoolEntryAccept(n2, this);
                }
                this.clearConstantPoolIndices();
                break;
            }
            default: {
                this.clearConstantPoolIndices();
            }
        }
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
        String string = stringCpInfo.getString(classFile);
        String string2 = ClassUtil.internalClassName(string);
        stringCpInfo.referencedClassFile = this.findClass(string2);
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
        if (this.note && (this.noteExceptionMatcher == null || !this.noteExceptionMatcher.matches(classCpInfo.getName(classFile)))) {
            ++this.noteCount;
            System.err.println("Note: " + ClassUtil.externalClassName(classFile.getName()) + " calls '(" + ClassUtil.externalClassName(classCpInfo.getName(classFile)) + ")Class.forName(variable).newInstance()'");
        }
    }

    private void clearConstantPoolIndices() {
        this.ldcStringCpIndex = -1;
        this.invokestaticMethodRefCpIndex = -1;
        this.invokevirtualMethodRefCpIndex = -1;
    }

    private ClassFile findClass(String string) {
        ClassFile classFile = this.programClassPool.getClass(string);
        if (classFile == null) {
            classFile = this.libraryClassPool.getClass(string);
        }
        return classFile;
    }
}

