/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.Configuration;
import proguard.DataEntryReaderFactory;
import proguard.DuplicateClassFilePrinter;
import proguard.classfile.ClassPool;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassFilePresenceFilter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.io.ClassFileFilter;
import proguard.io.ClassFileReader;
import proguard.io.DataEntryReader;
import proguard.io.DirectoryPump;

public class InputReader {
    private Configuration configuration;

    public InputReader(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool classPool, ClassPool classPool2) throws IOException {
        int n;
        if (this.configuration.programJars == null) {
            throw new IOException("The input is empty. You have to specify one or more '-injars' options.");
        }
        WarningPrinter warningPrinter = this.configuration.warn ? new WarningPrinter(System.err) : null;
        WarningPrinter warningPrinter2 = this.configuration.note ? new WarningPrinter(System.out) : null;
        DuplicateClassFilePrinter duplicateClassFilePrinter = this.configuration.note ? new DuplicateClassFilePrinter(warningPrinter2) : null;
        this.readInput("Reading program ", this.configuration.programJars, (DataEntryReader)new ClassFileFilter(new ClassFileReader(false, this.configuration.skipNonPublicLibraryClasses, this.configuration.skipNonPublicLibraryClassMembers, warningPrinter, new ClassFilePresenceFilter(classPool, duplicateClassFilePrinter, new ClassPoolFiller(classPool)))));
        if (classPool.size() == 0) {
            throw new IOException("The input doesn't contain any classes. Did you specify the proper '-injars' options?");
        }
        if (this.configuration.libraryJars != null) {
            this.readInput("Reading library ", this.configuration.libraryJars, (DataEntryReader)new ClassFileFilter(new ClassFileReader(true, this.configuration.skipNonPublicLibraryClasses, this.configuration.skipNonPublicLibraryClassMembers, warningPrinter, new ClassFilePresenceFilter(classPool, duplicateClassFilePrinter, new ClassFilePresenceFilter(classPool2, duplicateClassFilePrinter, new ClassPoolFiller(classPool2))))));
        }
        if (this.configuration.note && (n = warningPrinter2.getWarningCount()) > 0) {
            System.err.println("Note: there were " + n + " duplicate class definitions.");
        }
        if (this.configuration.warn && (n = warningPrinter.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + n + " classes in incorrectly named files.");
            System.err.println("         You should make sure all file names correspond to their class names.");
            System.err.println("         The directory hierarchies must correspond to the package hierarchies.");
            if (!this.configuration.ignoreWarnings) {
                System.err.println("         If you don't mind the mentioned classes not being written out,");
                System.err.println("         you could try your luck using the '-ignorewarnings' option.");
                throw new IOException("Please correct the above warnings first.");
            }
        }
    }

    private void readInput(String string, ClassPath classPath, DataEntryReader dataEntryReader) throws IOException {
        this.readInput(string, classPath, 0, classPath.size(), dataEntryReader);
    }

    public void readInput(String string, ClassPath classPath, int n, int n2, DataEntryReader dataEntryReader) throws IOException {
        for (int i = n; i < n2; ++i) {
            ClassPathEntry classPathEntry = classPath.get(i);
            if (classPathEntry.isOutput()) continue;
            this.readInput(string, classPathEntry, dataEntryReader);
        }
    }

    private void readInput(String string, ClassPathEntry classPathEntry, DataEntryReader dataEntryReader) throws IOException {
        try {
            DataEntryReader dataEntryReader2 = DataEntryReaderFactory.createDataEntryReader(string, classPathEntry, dataEntryReader);
            DirectoryPump directoryPump = new DirectoryPump(classPathEntry.getFile());
            directoryPump.pumpDataEntries(dataEntryReader2);
        }
        catch (IOException iOException) {
            throw new IOException("Can't read [" + classPathEntry + "] (" + iOException.getMessage() + ")");
        }
    }
}

