/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.MemberInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.obfuscate.MemberInfoObfuscator;

public class MemberInfoNameConflictFilter
implements MemberInfoVisitor {
    private static final String CONFLICT = "_ CONFLICT _";
    private MemberInfoVisitor memberInfoVisitor;

    public MemberInfoNameConflictFilter(MemberInfoVisitor memberInfoVisitor) {
        this.memberInfoVisitor = memberInfoVisitor;
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        if (MemberInfoNameConflictFilter.hasConflictingName(programFieldInfo)) {
            this.memberInfoVisitor.visitProgramFieldInfo(programClassFile, programFieldInfo);
        }
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        if (MemberInfoNameConflictFilter.hasConflictingName(programMethodInfo)) {
            this.memberInfoVisitor.visitProgramMethodInfo(programClassFile, programMethodInfo);
        }
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }

    static void markConflictingName(MemberInfo memberInfo) {
        MemberInfoObfuscator.setNewMemberName(memberInfo, CONFLICT);
    }

    static boolean hasConflictingName(MemberInfo memberInfo) {
        String string = MemberInfoObfuscator.newMemberName(memberInfo);
        return string != null && string.equals(CONFLICT);
    }
}

