/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.ClassFile;
import proguard.classfile.FieldInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.MethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.obfuscate.ClassFileObfuscator;
import proguard.obfuscate.MemberInfoObfuscator;

public class NameMarker
implements ClassFileVisitor,
MemberInfoVisitor {
    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        this.keepClassName(programClassFile);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        this.keepClassName(libraryClassFile);
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        this.keepFieldName(programClassFile, programFieldInfo);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.keepMethodName(programClassFile, programMethodInfo);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
        this.keepFieldName(libraryClassFile, libraryFieldInfo);
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        this.keepMethodName(libraryClassFile, libraryMethodInfo);
    }

    public void keepClassName(ClassFile classFile) {
        ClassFileObfuscator.setNewClassName(classFile, classFile.getName());
    }

    private void keepFieldName(ClassFile classFile, FieldInfo fieldInfo) {
        MemberInfoObfuscator.setFixedNewMemberName(fieldInfo, fieldInfo.getName(classFile));
    }

    private void keepMethodName(ClassFile classFile, MethodInfo methodInfo) {
        String string = methodInfo.getName(classFile);
        if (!string.equals("<clinit>") && !string.equals("<init>")) {
            MemberInfoObfuscator.setFixedNewMemberName(methodInfo, methodInfo.getName(classFile));
        }
    }
}

