/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.optimize.NonPrivateMethodMarker;

public class MethodPrivatizer
implements MemberInfoVisitor {
    private MemberInfoVisitor extraMemberInfoVisitor;

    public MethodPrivatizer() {
        this(null);
    }

    public MethodPrivatizer(MemberInfoVisitor memberInfoVisitor) {
        this.extraMemberInfoVisitor = memberInfoVisitor;
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        if (NonPrivateMethodMarker.canBeMadePrivate(programMethodInfo)) {
            programMethodInfo.u2accessFlags = AccessUtil.replaceAccessFlags(programMethodInfo.u2accessFlags, 2);
            if (this.extraMemberInfoVisitor != null) {
                this.extraMemberInfoVisitor.visitProgramMethodInfo(programClassFile, programMethodInfo);
            }
        }
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
    }
}

