/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.LibraryClassFile;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.shrink.UsageMarker;

public class UsedClassFileFilter
implements ClassFileVisitor {
    private UsageMarker usageMarker;
    private ClassFileVisitor classFileVisitor;

    public UsedClassFileFilter(UsageMarker usageMarker, ClassFileVisitor classFileVisitor) {
        this.usageMarker = usageMarker;
        this.classFileVisitor = classFileVisitor;
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        if (this.usageMarker.isUsed(programClassFile)) {
            this.classFileVisitor.visitProgramClassFile(programClassFile);
        }
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        if (this.usageMarker.isUsed(libraryClassFile)) {
            this.classFileVisitor.visitLibraryClassFile(libraryClassFile);
        }
    }
}

